// ReShade shader to simulate "free-aim" effect in FPS games.
// Author: wormcan. but not really... this was 99% made by Google AI Studio. I don't really know what's going on in here, but it seems like it works. ;-)

uniform float ZoomAmount <
  ui_type = "slider";
  ui_min = 0.0;
  ui_max = 1.0;
  ui_step = 0.01;
  ui_label = "Zoom Amount";
> = 0.1;

uniform bool InvertMouseX <
  ui_type = "bool";
  ui_label = "Invert Mouse X";
> = true;

uniform bool InvertMouseY <
  ui_type = "bool";
  ui_label = "Invert Mouse Y";
> = true;

float2 Zoom(float2 uv, float zoom, float mouseX, float mouseY)
{
    float2 center = float2(mouseX, mouseY);
    float2 offset = float2(0,0);

    float zoomFactor = 1.0 + zoom;
    float2 zoomUV = (uv - center) / zoomFactor + center + offset;

    return zoomUV;
}

// Declare the backbuffer texture with the correct type and bind it to ReShade's backbuffer.
uniform texture BackBufferTex : COLOR;

// Declare the backbuffer sampler, referencing the texture we just defined.
uniform sampler BackBufferSampler { Texture = BackBufferTex; };

// Declare the mouse coordinates uniform variable with the source attribute
uniform float2 f2Mouse <source="mousepoint";>;

void PS_Zoom(in float4 position : SV_Position, in float2 texcoord : TEXCOORD0, out float4 fragColor : SV_Target0)
{
    // Mouse position (0-1 range)
    float mouseX = f2Mouse.x / BUFFER_WIDTH;
    float mouseY = f2Mouse.y / BUFFER_HEIGHT;

    // Invert mouse axes if the checkboxes are checked.
    if(InvertMouseX)
        mouseX = 1.0 - mouseX;
    if(InvertMouseY)
        mouseY = 1.0 - mouseY;

    float2 zoomedTexcoord = Zoom(texcoord, ZoomAmount, mouseX, mouseY);

    // Sample from the zoomed texture coordinate using the defined sampler
    fragColor = tex2D(BackBufferSampler, zoomedTexcoord);
}


// Include the ReShade.fxh header to get the built-in variables and functions.
#include "ReShade.fxh"

technique FreeAim < ui_tooltip = "Simulate a free-aim effect in FPS games. High FOV recommended."; >
{
    pass
    {
        VertexShader = PostProcessVS;
        PixelShader = PS_Zoom;
    }
}